/* create constraints and indices script */

/*
-------------------------
-- create data table indices (41 indices)
-------------------------
*/

select 'starting full indexing run' as msg, cast('now' as date) as time from rdb$database;

/*
-------------------------
-- uniques (4 indices)
*/

select 'creating uniques indices' as msg, cast('now' as date) as time from rdb$database;

alter table uniques add constraint uniques_key_PK_IDX primary key (u_key);
create unique index uniques_signed_IDX on uniques (u_signed);
create unique index uniques_code_CK_IDX on uniques (u_code);
create index uniques_name_IDX on uniques (u_name);

select 'finished creating uniques indices' as msg, cast('now' as date) as time from rdb$database;

/*
-------------------------
hundred (6 indices)
*/

select 'creating hundred indices' as msg, cast('now' as date) as time from rdb$database;

alter table hundred add constraint hundred_key_PK_IDX primary key (h_key);
create index hundred_int_IDX on hundred (h_int);
create index hundred_signed_IDX on hundred (h_signed);
create index hundred_date_IDX on hundred (h_date);
create unique index hundred_code_CK_IDX on hundred (h_code);
create index hundred_name_IDX on hundred (h_name);

select 'finished creating hundred indices' as msg, cast('now' as date) as time from rdb$database;

/*
-------------------------
-- tenpct (9 indices)
*/

select 'creating tenpct indices' as msg, cast('now' as date) as time from rdb$database;

alter table tenpct add constraint tenpct_key_code_PK_IDX primary key (t_key, t_code);
create index tenpct_int_IDX on tenpct (t_int);
create index tenpct_signed_IDX on tenpct (t_signed);
create index tenpct_float_IDX on tenpct (t_float);
create index tenpct_double_IDX on tenpct (t_double);
create index tenpct_decim_IDX on tenpct (t_decim);
create index tenpct_date_IDX on tenpct (t_date);
create unique index tenpct_code_CK_IDX on tenpct (t_code);
create index tenpct_name_IDX on tenpct (t_name);

select 'finished creating tenpct indices' as msg, cast('now' as date) as time from rdb$database;

/*
-------------------------
-- updates (6 indices, 1 foreign key)
*/

select 'creating updates indices' as msg, cast('now' as date) as time from rdb$database;

alter table updates add constraint updates_key_PK_IDX primary key (p_key);
create index updates_int_IDX on updates (p_int);
alter table updates add constraint updates_int_FK foreign key (p_int) references hundred (h_key);
create index updates_signed_IDX on updates (p_signed);
create index updates_decim_IDX on updates (p_decim);
create index updates_date_IDX on updates (p_date);
create unique index updates_code_CK_IDX on updates (p_code);

select 'finished creating updates indices' as msg, cast('now' as date) as time from rdb$database;

/*
-------------------------
-- tenthou (5 indices)
*/

select 'creating tenthou indices' as msg, cast('now' as date) as time from rdb$database;

alter table tenthou add constraint tenthou_key_code_PK_IDX primary key (t_key, t_code);
create index tenthou_signed_IDX on tenthou (t_signed);
create index tenthou_decim_IDX on tenthou (t_decim);
create unique index tenthou_code_CK_IDX on tenthou (t_code);
create index tenthou_name_IDX on tenthou (t_name);

select 'finished creating tenthou indices' as msg, cast('now' as date) as time from rdb$database;

/*
-------------------------
-- hunthou (1 index)
*/

select 'creating hunthou indices' as msg, cast('now' as date) as time from rdb$database;

create index hunthou_signed_IDX on hunthou (h_signed);

select 'finished creating hunthou indices' as msg, cast('now' as date) as time from rdb$database;

/*
-------------------------
-- twomill (3 indices)
*/

select 'creating twomill indices' as msg, cast('now' as date) as time from rdb$database;

alter table twomill add constraint twomill_key_PK_IDX primary key (p_key);
create index twomill_date_IDX on twomill (p_date);
create unique index twomill_code_CK_IDX on twomill (p_code);

select 'finished creating twomill indices' as msg, cast('now' as date) as time from rdb$database;

/*
-------------------------
-- threemill (2 indices)
*/

select 'creating threemill indices' as msg, cast('now' as date) as time from rdb$database;

alter table threemill add constraint threemill_key_PK_IDX primary key (t_key);
create index threemill_signed_IDX on threemill (t_signed);

select 'finished creating threemill indices' as msg, cast('now' as date) as time from rdb$database;

/*
-------------------------
-- fourmill (2 indices)
*/

select 'creating fourmill indices' as msg, cast('now' as date) as time from rdb$database;

alter table fourmill add constraint fourmill_key_PK_IDX primary key (t_key);
create index fourmill_name_IDX on fourmill (t_name);

select 'finished creating fourmill indices' as msg, cast('now' as date) as time from rdb$database;

/*
-------------------------
-- fivemill (2 indices)
*/

select 'creating fivemill indices' as msg, cast('now' as date) as time from rdb$database;

alter table fivemill add constraint fivemill_key_PK_IDX primary key (h_key);
create unique index fivemill_code_CK_IDX on fivemill (h_code);

select 'finished creating fivemill indices' as msg, cast('now' as date) as time from rdb$database;

/*
-------------------------
-- fourram (1 index)
*/

select 'creating fourram indices' as msg, cast('now' as date) as time from rdb$database;

alter table fourram add constraint fourram_key_PK_IDX primary key (p_key);

select 'finished creating fourram indices' as msg, cast('now' as date) as time from rdb$database;

/*
-------------------------
-- create housekeeping table indices (5 indices)
-------------------------
*/

/*
-- update_int_history (2 indices)
*/

select 'creating update_int_history indices' as msg, cast('now' as date) as time from rdb$database;

alter table update_int_history add constraint up_int_hist_key_int_PK_IDX primary key (p_key, p_int);
create index update_int_history_int_IDX on update_int_history (p_int);

select 'finished creating update_int_history indices' as msg, cast('now' as date) as time from rdb$database;

/*
-- update_signed_history (2 indices)
*/

select 'creating update_signed_history indices' as msg, cast('now' as date) as time from rdb$database;

alter table update_signed_history add constraint up_sign_hist_key_sign_PK_IDX primary key (p_key, p_signed);
create index up_sign_hist_sign_IDX on update_signed_history (p_signed);

select 'finished creating update_signed_history indices' as msg, cast('now' as date) as time from rdb$database;

/*
-- del_history (1 index)
*/

select 'creating del_history indices' as msg, cast('now' as date) as time from rdb$database;

alter table del_history add constraint del_history_key_PK_IDX primary key (h_key);

select 'finished creating del_history indices' as msg, cast('now' as date) as time from rdb$database;

/*
-------------------------
-- end
-------------------------
*/

select 'finished full indexing run' as msg, cast('now' as date) as time from rdb$database;

commit;
exit;
